import { defineBackend } from '@aws-amplify/backend';
import { auth } from './auth/resource';
import { deleteUser } from './data/delete-user/resource';
import { inviteUser } from './data/invite-user/resource';
import { data, startOtpDataUpdate } from './data/resource';
import { env } from './env.setup';
import { extendBackend } from './extend-backend';
import { getAllStatewideServices } from './function/get-all-statewide-services/resource';
import { triggerPublishPreviewToLive } from './data/trigger-publish-preview-to-live/resource';

/**
 * @see https://docs.amplify.aws/react/build-a-backend/ to add storage, functions, and more
 */
export const backend = defineBackend({
  auth,
  startOtpDataUpdate,
  triggerPublishPreviewToLive,
  getAllStatewideServices,
  deleteUser,
  inviteUser,
  data,
});

export type Backend = typeof backend;

backend.addOutput({
  storage: {
    aws_region: env.BACKEND_AWS_S3_BUCKET_REGION,
    bucket_name: env.BACKEND_AWS_S3_BUCKET_NAME,
  },
})

extendBackend(backend)
